SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/* Start Changes for US1222 - Critical Question */

-- ================================================
-- Template generated from Template Explorer using:
-- Create Trigger (New Menu).SQL
--
-- Use the Specify Values for Template Parameters 
-- command (Ctrl-Shift-M) to fill in the parameter 
-- values below.
--
-- See additional Create Trigger templates for more
-- examples of different Trigger statements.
--
-- This block of comments will not be included in
-- the definition of the function.
-- ================================================
-- =============================================
-- Author:		<Voxco>
-- Create date: <2012/06/20>
-- Description:	<Create new field for US1222>
--     * Add field to table Response
--        1. Add Source field to be availlable to the trigger
--        2. Add CallId field to be availlable to the trigger
--     * Add field to table ResponseModifLog
--        1. Add CallId field to be availlable to the trigger
-- =============================================
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Source' AND object_id = OBJECT_ID(N'Response'))
BEGIN
  ALTER TABLE Response ADD Source nvarchar(MAX) NULL
END
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'CallId' AND object_id = OBJECT_ID(N'Response'))
BEGIN
  ALTER TABLE Response ADD CallId int default(0) NULL
END
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'RpsOpened' AND object_id = OBJECT_ID(N'Response'))
BEGIN
  ALTER TABLE Response ADD RpsOpened nvarchar(MAX) NULL
END
ELSE
BEGIN
  ALTER TABLE Response ALTER COLUMN RpsOpened nvarchar(MAX) NULL
END
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'CallId' AND object_id = OBJECT_ID(N'ResponseModifLog'))
BEGIN
  ALTER TABLE ResponseModifLog ADD CallId int default(0) NULL
END
GO


/****** Object:  StoredProcedure [dbo].[Sp_UpdateRespondentResponseCode]    Script Date: 06/20/2012 12:30:37 ******/
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_UpdateRespondentResponseCode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponseCode]
GO

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponseCode]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(10),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max)
 
AS
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN collectmode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         RpsContent = @RpsContent,
         CallId = @CallId,
         [Source] = @Source
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  IF @@ROWCOUNT = 0
  BEGIN
 INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source])
 VALUES    (@RpsRespondent,
     @ProjectId,
     @CollectMode,
     @UserId,
     Getutcdate(),
     @RpsQuestion,
     @RpsMatrix,
     @RpsMention,
     @RpsContent,
     '',
     @rpsType,
     @CallId,
     @Source)
  END
GO


/****** Object:  StoredProcedure [dbo].[Sp_UpdateRespondentResponse]    Script Date: 06/20/2012 12:30:35 ******/
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_UpdateRespondentResponse]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(10),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsOpened     NTEXT,
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max)
 
AS
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         RpsContent = @RpsContent,
         RpsOpened = @RpsOpened,
         CallId = @CallId,
         [Source] = @Source
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  IF @@ROWCOUNT = 0
  BEGIN
    INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source])
 VALUES    (@RpsRespondent,
     @ProjectId,
     @CollectMode,
     @UserId,
     Getutcdate(),
     @RpsQuestion,
     @RpsMatrix,
     @RpsMention,
     @RpsContent,
     @rpsOpened,
     @rpsType,
     @CallId,
     @Source)
  END
GO




-- =============================================
-- Author:      Voxco
-- Create date: 2012/06/20
-- Description: Add a rtigger to the table Response.
--              This trigger will audit any modification to the table Response 
--              into the table ModificationResponseLog
-- =============================================
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[VX_TR_ReponseModifLog]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
  DROP TRIGGER [dbo].[VX_TR_ReponseModifLog]
GO


CREATE TRIGGER [dbo].[VX_TR_ReponseModifLog]
   ON  [dbo].[Response]
   AFTER UPDATE, INSERT
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;

  -- From the Installation configuration, the option for Audit of the Response table.
  DECLARE @AuditOn varchar(250)

  SET @AuditOn = (SELECT Installation.InsValue 
                  FROM Installation 
                  WHERE Installation.InsSection='PROJECT' and
                        Installation.InsIdent='TRACK RESPONSE MODIFICATIONS')

  SET @AuditOn = IsNull(@AuditOn, '0')
  
  -- If we want to bypass this depending on the source we may add  <or inserted.[Source]='{sourceToUse}'>
  --   to this IF condition or vice versa to supress audit from a particular [Source]
  IF (@AuditOn = '1')
  BEGIN
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, deleted.RpsContent, 
             inserted.RpsOpened, deleted.RpsOpened, inserted.[Source], inserted.modifiedby, inserted.modified, inserted.CallId
      FROM inserted left join deleted
      ON inserted.RpsRespondent = deleted.RpsRespondent and 
         inserted.RpsQuestion = deleted.RpsQuestion and 
         inserted.RpsMatrix = deleted.RpsMatrix and 
         inserted.RpsMention = deleted.RpsMention and 
         inserted.RpsType = deleted.RpsType
      WHERE ( inserted.RpsContent<>isnull(deleted.RpsContent,'') ) or (inserted.RpsOpened <> isnull(deleted.RpsOpened,'') )
END
END
GO



/* End Changes for US1222 - Critical Question */


/* Start Changes for US1194 - Hard callback  */
/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackExtendedRules]    Script Date: 06/22/2012 14:26:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackExtendedRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackExtendedRules]    Script Date: 06/22/2012 14:26:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
 @ReturnDeleted bit= 0
AS
BEGIN
 SET NOCOUNT ON;
 SELECT ExtNumber, ExtNewResult, ExtLifeState, ExtResultsSequence, ExtCallback,
  IsNull(ExtInterviewer,'') as ExtInterviewer, ExtDelay, ExtUnit, ExtPriority, ExtPriorityType, IsNull(DialingMode,'-1') as DialingMode, ExtWaveInc,projectId,modifiedBy,modified, SynchResult,Id,deleted,RestrictionOverride
 FROM  ExtendedRules
 WHERE deleted = 0 or deleted = @ReturnDeleted
 ORDER BY ExtNumber
END

GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackExtendedRulesById]    Script Date: 06/22/2012 14:26:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackExtendedRulesById]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRulesById]
GO
/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackExtendedRulesById]    Script Date: 06/22/2012 14:26:41 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRulesById]
 @Id int
AS
BEGIN
 SET NOCOUNT ON;
 SELECT ExtNumber, ExtNewResult, ExtLifeState, ExtResultsSequence, ExtCallback,
  IsNull(ExtInterviewer,'') as ExtInterviewer, ExtDelay, ExtUnit, ExtPriority, ExtPriorityType, IsNull(DialingMode,'-1') as DialingMode, ExtWaveInc,projectId,modifiedBy,modified, SynchResult,Id,deleted,RestrictionOverride
 FROM  ExtendedRules
 WHERE Id = @Id and deleted = 0 
 ORDER BY ExtNumber
END

GO



/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackRules]    Script Date: 06/22/2012 14:26:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetCallBackRules]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackRules]    Script Date: 06/22/2012 14:26:57 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackRules]
 @ReturnDeleted bit= 0 
AS
BEGIN  
 SET NOCOUNT ON;
 SELECT RulNumber, RulResult, RulCount, RulConsecutive, RulCallback,IsNull(RulInterviewer,'') as RulInterviewer, RulDelay, RulUnit, RulPriority, RulPriorityType, 
  IsNull(DialingMode,'-1') as DialingMode, RulWaveInc,projectId,modifiedBy,modified, SynchResult,Id, deleted,RestrictionOverride
 FROM  Rules 
 WHERE deleted = 0 or deleted = @ReturnDeleted
 ORDER BY rulresult,rulcount
END

GO


/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackRulesById]    Script Date: 06/22/2012 14:27:12 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackRulesById]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetCallBackRulesById]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetCallBackRulesById]    Script Date: 06/22/2012 14:27:12 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackRulesById]
 @Id int
AS
BEGIN
 SET NOCOUNT ON;
 SELECT RulNumber, RulResult, RulCount, RulConsecutive, RulCallback,IsNull(RulInterviewer,'') as RulInterviewer, RulDelay, RulUnit, RulPriority, RulPriorityType, 
  IsNull(DialingMode,'-1') as DialingMode, RulWaveInc,projectId,modifiedBy,modified, SynchResult,Id, deleted,RestrictionOverride
 FROM Rules 
 WHERE Id = @Id and deleted = 0
 ORDER BY rulresult,rulcount
END

GO


/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateCallBackExtendedRules]    Script Date: 06/22/2012 14:27:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackExtendedRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateCallBackExtendedRules]    Script Date: 06/22/2012 14:27:28 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
@NewExtendedRules xml
AS
BEGIN
 SET NOCOUNT ON;
 SELECT 
     colx.value('Id[1]','int') as Id 
  ,colx.value('ExtNumber[1]','int') as ExtNumber
  ,colx.value('ExtNewResult[1]','varchar(2)') as ExtNewResult
  ,colx.value('ExtLifeState[1]','varchar(3900)') as ExtLifeState
  ,colx.value('ExtResultsSequence[1]','varchar(4000)')  as ExtResultsSequence
  ,colx.value('ExtCallback[1]','bit') as ExtCallback
  ,colx.value('ExtInterviewer[1]','varchar(10)')      as ExtInterviewer
  ,colx.value('ExtDelay[1]','int') as ExtDelay
  ,colx.value('ExtUnit[1]','int') as ExtUnit
  ,colx.value('ExtPriority[1]','int') as ExtPriority
  ,colx.value('ExtPriorityType[1]','int') as ExtPriorityType
  ,colx.value('DialingMode[1]','int') as DialingMode
  ,colx.value('ExtWaveInc[1]','bit') as ExtWaveInc
  ,colx.value('projectId[1]','int') as projectid
  ,colx.value('modifiedBy[1]','int') as modifiedBy
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified    
  ,colx.value('SynchResult[1]','int') as SynchResult    
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride  
 INTO #TMP FROM @NewExtendedRules.nodes('NewDataSet/ExtendedRules') AS Tabx(Colx)
 update ExtendedRules set deleted = 1 
 from (
 select 
 Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride
 from ExtendedRules where deleted = 0
 except
 select Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride
 from #TMP 
 )b
 where deleted = 0  and ExtendedRules.Id = b.Id
     update ExtendedRules set ExtendedRules.modifiedBy = #TMP.modifiedBy ,ExtendedRules.modified = #TMP.modified from #TMP
   where ExtendedRules.deleted = 1 and #TMP.Id = ExtendedRules.Id 
 insert into ExtendedRules
 (ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride)
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,isnull(ExtInterviewer,'') as ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride
 from #TMP where ExtNumber in (
 select ExtNumber from 
 (
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride
 from #TMP 
 except
 select 
 ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride
 from ExtendedRules  where deleted = 0
 )b)
 DROP TABLE #TMP
END

GO


/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateCallBackRules]    Script Date: 06/22/2012 14:31:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateCallBackRules]    Script Date: 06/22/2012 14:31:09 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
 @NewRules xml
AS
BEGIN
 SET NOCOUNT ON;
SELECT
   colx.value('Id[1]','int') as Id 
  ,colx.value('RulNumber[1]','int') as RulNumber
  ,colx.value('RulResult[1]','varchar(2)') as RulResult
  ,colx.value('RulCount[1]','int') as RulCount
  ,colx.value('RulConsecutive[1]','bit') as RulConsecutive
  ,colx.value('RulCallback[1]','bit') as RulCallback
  ,colx.value('RulInterviewer[1]','varchar(10)') as RulInterviewer
  ,colx.value('RulDelay[1]','int') as RulDelay
  ,colx.value('RulUnit[1]','int') as RulUnit
  ,colx.value('RulPriority[1]','int') as RulPriority
  ,colx.value('RulPriorityType[1]','int') as RulPriorityType
  ,colx.value('RulWaveInc[1]','bit')as RulWaveInc
  ,colx.value('projectId[1]','int') as projectid
  ,colx.value('modifiedBy[1]','int') as modifiedBy
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified
  ,colx.value('SynchResult[1]','int') as SynchResult
  ,colx.value('DialingMode[1]','int') as DialingMode
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride
 INTO #TMP FROM @NewRules.nodes('NewDataSet/CallBackRule') AS Tabx(Colx)
 update Rules 
 set deleted = 1 
 from (
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride
  from Rules where deleted = 0
  except
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride
  from #TMP 
  )b
 where deleted = 0  and Rules.Id = b.Id
  update rules set rules.modifiedBy = #TMP.modifiedBy ,rules.modified = #TMP.modified from #TMP
  where rules.deleted = 1 and #TMP.Id = rules.Id  
 insert into Rules (RulNumber,RulResult,RulCount,RulConsecutive,RulCallback,
  RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride)
   select #TMP.RulNumber,#TMP.RulResult,#TMP.RulCount,#TMP.RulConsecutive,#TMP.RulCallback,
  isnull(#TMP.RulInterviewer,'') as RulInterviewer,#TMP.RulDelay,#TMP.RulUnit,#TMP.RulPriority,#TMP.RulPriorityType,#TMP.RulWaveInc,#TMP.projectId,#TMP.modifiedBy,#TMP.modified,#TMP.SynchResult,#TMP.DialingMode
  ,#TMP.RestrictionOverride
 from #TMP 
  join (
  select RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride
  from #TMP 
  except
  select RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride
  from Rules where deleted = 0) b  
   on #TMP.RulResult = b.RulResult and #TMP.RulCount = b.RulCount and #TMP.RulConsecutive = b.RulConsecutive and #TMP.RulCallback = b.RulCallback
   and isnull(#TMP.RulInterviewer,'') = isnull(b.RulInterviewer,'') and #TMP.RulDelay = b.RulDelay and #TMP.RulUnit = b.RulUnit 
   and isnull(#TMP.RulPriority,0) = isnull(b.RulPriority,0) and isnull(#TMP.RulPriorityType,0) = isnull(b.RulPriorityType,0)
   and #TMP.RulWaveInc = b.RulWaveInc and #TMP.projectId = b.projectId and #TMP.SynchResult = b.SynchResult
   and isnull(#TMP.DialingMode,-1) = isnull(b.DialingMode,-1) and isnull(#TMP.RestrictionOverride,0) = isnull(b.RestrictionOverride,0)
 DROP TABLE #TMP
END
GO
/* End Changes for US1194 - Hard callback  */



/* Start Changes for US1679 - CallBack rule And Time Slot  */
-- =============================================
-- Update Respondent.RestimeSlot  field from Bit to to int and add NOT NULLABLE and default value consrtaint of 0
-- April 2012 
-- =============================================
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ResTimeSlot' AND object_id = OBJECT_ID(N'Respondent'))
BEGIN
  ALTER TABLE Respondent ADD ResTimeSlot int default(0) NOT NULL
END
ELSE
BEGIN
  -- Need to update all the value of ResTimeSlot from null to 0
  UPDATE Respondent set ResTimeSlot = 0 where ResTimeSlot is null
  -- update the field of the table
  ALTER TABLE Respondent ALTER COLUMN ResTimeSlot int NOT NULL
  -- Update the constrian of the field (default value is a constraint
  IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DF_Respondent_ResTimeSlot]') AND type= N'D')
    -- Drop it first
    ALTER TABLE Respondent DROP CONSTRAINT [DF_Respondent_ResTimeSlot]
  -- Add a new constriant to the table
  ALTER TABLE Respondent ADD CONSTRAINT DF_Respondent_ResTimeSlot DEFAULT 0 FOR ResTimeSlot
END
GO


-- =============================================
-- Update Historic.HisTimeSlot field from NULLABLE to NOT NULLABLE and default value consrtaint of 0
-- April 2012 
-- =============================================
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'HisTimeSlot' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
  ALTER TABLE Historic ADD HisTimeSlot int default(0) NOT NULL
END
ELSE
BEGIN
  -- Need to update all the value of ResTimeSlot from null to 0
  UPDATE Historic set HisTimeSlot = 0 where HisTimeSlot is null
  -- update the field of the table
  ALTER TABLE Historic ALTER COLUMN HisTimeSlot int NOT NULL
  -- Update the constrian of the field (default value is a constraint
  IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DF_Historic_HisTimeSlot]') AND type= N'D')
    -- Drop it first
    ALTER TABLE Historic DROP CONSTRAINT [DF_Historic_HisTimeSlot]
  -- Add a new constriant to the table
  ALTER TABLE Historic ADD CONSTRAINT DF_Historic_HisTimeSlot DEFAULT 0 FOR HisTimeSlot
END
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateCallBackRules]    Script Date: 06/22/2012 14:31:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateRespondent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_UpdateRespondent]
GO

CREATE PROCEDURE [dbo].[sp_UpdateRespondent]  
	@ProjectId int,
	@UserId int,
	@CollectMode int,
	@ResRespondent varchar(10),
	@ResLanguage int,
	@ResTimeZone int,
	@ResCallBackDate DateTime,
	@ResIntervCall varchar(10),
	@ResTimeSlot int,
	@ResCallCount int,
	@ResLastCallDate datetime,
	@ResVersion varchar(10),
	@ResPriority int,
	@ResCompleted bit,
	@ResConfidPhone bit,
	@ResSeed float,
	@ResPhone varchar(20),
	@ResCodeResult varchar(2),
	@ResWaveNo int,
	@ResBlocked bit,
	@ResCompPredictive bit,
	@ResCall bit,
	@ResMonitored bit,
	@ResLastCompQuest int,
	@ResPreviousCallDate DateTime,
	@ResWaveImportNo int,
	@ServerTimeZone int,
	@DialingMode int = NULL, -- Null => Don't change;
	@IntLevel int = NULL, -- Null => Don't change;
	@RestrictionOverride bit = NULL -- Null => Don't change;
AS
	update Respondent set
		projectId = @ProjectId,
		collectMode = case when @CollectMode <0 then collectMode else @CollectMode end,
		modifiedBy = @UserId,
		modified = GETUTCDATE(),
		ResLanguage = @ResLanguage,
		ResTimeZone = @ResTimeZone,
		ResCallbackDate = dbo.[VX_fn_ToUTC](@ResCallBackDate, @ServerTimeZone),
		ResIntervCall = @ResIntervCall,
		ResTimeSlot = @ResTimeSlot,
		ResCallCount = @ResCallCount,
		ResLastCallDate = @ResLastCallDate,
		ResVersion = @ResVersion,
		ResPriority = @ResPriority,
		ResCompleted = @ResCompleted,
		ResConfidPhone = @ResConfidPhone,
		ResSeed = @ResSeed,
		Resphone = @ResPhone,
		ResCodeResult = @ResCodeResult,
		ResWaveNo = @ResWaveNo,
		ResBlocked = @ResBlocked,
		ResCompPredictive = @ResCompPredictive,
		ResCall = @ResCall,
		ResMonitored = @ResMonitored,
		ResLastCompQuest = @ResLastCompQuest,
		ResPreviousCallDate = @ResPreviousCallDate,
		ResWaveImportNo = @ResWaveImportNo,
		DialingMode = IsNull(@DialingMode,DialingMode), -- If not specified, leave original value
		IntLevel = IsNull(@IntLevel,IntLevel),
		RestrictionOverride = IsNull(@RestrictionOverride,RestrictionOverride)
	where 
		ResRespondent = @ResRespondent

	if @@ROWCOUNT = 0
	begin
		insert into respondent
		(
			ResRespondent,
			ProjectId,
			CollectMode,
			ModifiedBy,
			Modified,
			ResLanguage,
			ResTimeZone,
			ResCallBackDate,
			ResIntervCall,
			ResTimeSlot,
			ResCallCount,
			ResLastCallDate,
			ResVersion,
			ResPriority,
			ResCompleted,
			ResConfidPhone,
			ResSeed,
			ResPhone,
			ResCodeResult,
			ResWaveNo,
			ResBlocked,
			ResCompPredictive,
			ResCall,
			ResMonitored,
			ResLastCompQuest,
			ResPreviousCallDate,
			ResWaveImportNo,
			DialingMode,
			IntLevel,
			RestrictionOverride)
		values
		(
			@ResRespondent,
			@ProjectId,
			@CollectMode,
			@UserId,
			GETUTCDATE(),
			@ResLanguage,
			@ResTimeZone,
			dbo.VX_fn_ToUTC(@ResCallBackDate, @ServerTimeZone),
			@ResIntervCall,
			@ResTimeSlot,
			@ResCallCount,
			@ResLastCallDate,
			@ResVersion,
			@ResPriority,
			@ResCompleted,
			@ResConfidPhone,
			@ResSeed,
			@ResPhone,
			@ResCodeResult,
			@ResWaveNo,
			@ResBlocked,
			@ResCompPredictive,
			@ResCall,
			@ResMonitored,
			@ResLastCompQuest,
			@ResPreviousCallDate,
			@ResWaveImportNo,
			IsNull(@DialingMode,0),
			IsNull(@IntLevel,0),
			IsNull(@RestrictionOverride,0)
		) 
	end

GO


IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondenthistory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondenthistory]
GO

/****** Object:  StoredProcedure [dbo].[Sp_updaterespondenthistory]    Script Date: 03/07/2012 15:33:16 ******/
CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
                @ProjectId           INT,
                @CollectMode         INT,
                @HisRespondent       VARCHAR(10),
                @HisCallNumber       INT,
                @HisInterviewer      VARCHAR(10),
                @HisResult           VARCHAR(2),
                @HisCallDate         DATETIME,
                @HisTimeSlot         INT,
                @HisCallDuration     INT,
                @HisDataType         INT,
                @HisStartQuestion    VARCHAR(10),
                @HisEndQuestion      VARCHAR(10),
                @HisMonitoring       BIT,
                @HisDialerLine       INT,
                @HisWait             INT,
                @HisPause            INT,
                @HisFileReference    VARCHAR(120),
                @HisPreviousCallDate DATETIME,
                @HisLifeState        VARCHAR(2),
                @HisPhone            VARCHAR(20) = NULL,
                @DialingMode         INT = NULL, -- Null => Do not change
                @LevelChanged        BIT = 0,
                @Notes               NVARCHAR(MAX) = NULL,
                @RuleId              INT = NULL,
                @ExtRuleId           INT = NULL,
                @NextCBKDate         DATETIME = NULL
AS
  UPDATE historic
  SET    hisrespondent = @HisRespondent,
         hiscallnumber = @HisCallNumber,
         hisinterviewer = @HisInterviewer,
         hisresult = @HisResult,
         hiscalldate = @HisCallDate,
         histimeslot = @HisTimeSlot,
         hiscallduration = @HisCallDuration,
         hisdatatype = @HisDataType,
         hisstartquestion = @HisStartQuestion,
         hisendquestion = @HisEndQuestion,
         hismonitoring = @HisMonitoring,
         hisdialerline = @HisDialerLine,
         hiswait = @HisWait,
         hispause = @HisPause,
         hisfilereference = @HisFileReference,
         hispreviouscalldate = @HisPreviousCallDate,
         hislifestate = @HisLifeState,
         projectid = @projectId,
         collectmode = @collectMode,
         HisPhone = @HisPhone,
         DialingMode = IsNull(@DialingMode,DialingMode),
         LevelChanged = @LevelChanged,
         Notes = @Notes,
         RuleId = @RuleId,
         ExtRuleId = @ExtRuleId,
         NextCallBack = @NextCBKDate
  WHERE  hisrespondent = @HisRespondent
         AND hiscallnumber = @HisCallNumber
         
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO historic
                 (hisrespondent,
                  hiscallnumber,
                  hisinterviewer,
                  hisresult,
                  hiscalldate,
                  histimeslot,
                  hiscallduration,
                  hisdatatype,
                  hisstartquestion,
                  hisendquestion,
                  hismonitoring,
                  hisdialerline,
                  hiswait,
                  hispause,
                  hisfilereference,
                  hispreviouscalldate,
                  hislifestate,
                  projectid,
                  collectmode,
                  HisPhone,
                  DialingMode,
                  LevelChanged,
                  Notes,
                  RuleId,
                  ExtRuleId,
                  NextCallBack)
      VALUES     (@HisRespondent,
                  @HisCallNumber,
                  @HisInterviewer,
                  @HisResult,
                  @HisCallDate,
                  @HisTimeSlot,
                  @HisCallDuration,
                  @HisDataType,
                  @HisStartQuestion,
                  @HisEndQuestion,
                  @HisMonitoring,
                  @HisDialerLine,
                  @HisWait,
                  @HisPause,
                  @HisFileReference,
                  @HisPreviousCallDate,
                  @HisLifeState,
                  @projectId,
                  @collectMode, 
                  @HisPhone,
                  IsNull(@DialingMode,0),
                  @LevelChanged,
                  @Notes,
                  @RuleId,
                  @ExtRuleId,
                  @NextCBKDate)
    END
GO

/* End Changes for US1679 - CallBack rule Anfsd Time Slot  */

